package com.twentyfouri.tvlauncher.utils

import android.content.Context
import android.graphics.drawable.Drawable
import android.util.Log
import com.bumptech.glide.request.RequestOptions
import com.bumptech.glide.request.target.Target
import com.bumptech.glide.signature.ObjectKey
import com.twentyfouri.androidcore.utils.GenericGlideImageSpecification
import com.twentyfouri.tvlauncher.Flavor

class ExpirableGlideImageSpecification: GenericGlideImageSpecification<String> {

    constructor(url: String) : super(url, RequestOptions()) {}
    constructor(url: String, placeholderId: Int) : super(url, RequestOptions().apply { placeholder(placeholderId) }) {}
    constructor(url: String, options: RequestOptions) : super(url, options) {}

    override fun toString(): String = "GlideImageSpecification($url)"

    override fun startLoading(context: Context, target: Target<Drawable>) {
        requestOptions?.apply{signature(ObjectKey(Flavor().glideCacheExpirationInterval))}
        super.startLoading(context, target)
    }
}